/*
 * Decompiled with CFR 0.152.
 */
package dev.zy.sensorboard.processor;

import com.fazecast.jSerialComm.SerialPort;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SerialMonitor {
    private SerialPort com;

    public SerialPort getCom() {
        return this.com;
    }

    public void setCom(SerialPort com) {
        this.com = com;
    }

    public void initSerialPort() {
        if (this.com != null && this.com.isOpen()) {
            this.closePort();
        }
        this.com.openPort();
        this.com.setFlowControl(0);
        this.com.setComPortParameters(115200, 8, 1, 0);
        this.com.setComPortTimeouts(272, 1000, 1000);
    }

    public void closePort() {
        if (this.com != null) {
            this.com.removeDataListener();
            this.com.closePort();
        }
    }

    public String getData() {
        int bytesAvailable = this.com.bytesAvailable();
        byte[] buffer = new byte[bytesAvailable];
        this.com.readBytes(buffer, bytesAvailable);
        String ret = new String(buffer);
        return ret;
    }

    public void sendData(String command) throws Exception {
        this.com.writeBytes(command.getBytes(), command.length());
    }

    public List<String> getPortNames() {
        return Arrays.stream(SerialPort.getCommPorts()).map(SerialPort::getSystemPortName).collect(Collectors.toList());
    }

    public String writeAndRead(String command) {
        byte[] reslutData = null;
        try {
            this.com.writeBytes(command.getBytes(), command.length());
            int i = 0;
            while (this.com.bytesAvailable() > 0 && i++ < 5) {
                Thread.sleep(20L);
            }
            byte[] readBuffer = new byte[this.com.bytesAvailable()];
            int numRead = this.com.readBytes(readBuffer, readBuffer.length);
            reslutData = readBuffer;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new String(reslutData);
    }
}

